<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trainer extends Model 
{

    protected $table = 'trainers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lastname', 'date_of_birth', 'image', 'status', 'slug', 'training_id');

    public function athletes()
    {
        return $this->belongsToMany('App\Models\Athlete');
    }

    public function trainings()
    {
        return $this->hasMany('App\Models\Training');
    }

    public function disciplines()
    {
        return $this->belongsToMany('App\Models\Discipline');
    }

    public function divisions()
    {
        return $this->belongsToMany('App\Models\Division');
    }

}